/******************************************************************************
													            Copyright (c) Freescale 2005
File Name	 :	$RCSfile: target.h,v $

Engineer		 :	$Author: r32151 $

Location		 :	EKB

Date Created	  :	02/03/2005

Current Revision :	$Revision: 1.0 $

Notes            :  


DESCRIPTION:  definitions for target specifics such as clock speed        
                                                                          
NOTE: Modify this file depending on the crystal frequency of the target   
                                                                          
AUTHOR: Martyn Gallop        LOCATION: EKB      LAST EDIT DATE: 01/03/02  
                                                                          
UPDATE HISTORY                                                            
REV      	AUTHOR      DATE       	DESCRIPTION OF CHANGE                    
---      	------      ---------   ---------------------                    
1.0      	r32151    	03/06/01	                                         
1.1			r32151    	30/07/01 - Added KHz version of XTAL_FREQ
									    	- Reformated file info section
1.2			r32151		09/10/01	- added equations from xtal.h
2.0			r32151  		01/03/02	- Rewritten to use 'long' values and 
									  		  support rewrite of SetPLL => PLL_Set.
										   - PLL is disabled by default
2.1			r32151		13/10/03	- Added checks for ATD and PLL clocks
3.0			r32151		22/12/03 - Expanded memory remap support.
4.0         r32151      26/01/06 - Updated for S12XE                                             
                                                                           

     *******************************************************************
     * File created by: Freescale East Kilbride MCD Applications Group *
     *******************************************************************

                                                                          
******************************************************************************/
/*===========================================================================*/
/* Freescale reserves the right to make changes without further notice to any*/
/* product herein to improve reliability, function, or design. Freescale does*/
/* not assume any  liability arising  out  of the  application or use of any */
/* product,  circuit, or software described herein;  neither  does it convey */
/* any license under its patent rights  nor the  rights of others.  Freescale*/
/* products are not designed, intended,  or authorized for use as components */
/* in  systems  intended  for  surgical  implant  into  the  body, or  other */
/* applications intended to support life, or  for any  other application  in */
/* which the failure of the Freescale product  could create a situation where*/
/* personal injury or death may occur. Should Buyer purchase or use Freescale*/
/* products for any such intended  or unauthorized  application, Buyer shall */
/* indemnify and  hold  Freescale  and its officers, employees, subsidiaries,*/
/* affiliates,  and distributors harmless against all claims costs, damages, */
/* and expenses, and reasonable  attorney  fees arising  out of, directly or */
/* indirectly,  any claim of personal injury  or death  associated with such */
/* unintended or unauthorized use, even if such claim alleges that  Freescale*/
/* was negligent regarding the  design  or manufacture of the part. Freescale*/
/* and the Freescale logo* are registered trademarks of Freescale Ltd.       */
/*****************************************************************************/

#ifndef TARGET_H        /*prevent duplicated includes*/
#define TARGET_H

/****User Defines ****/

#define OSCCLK_FREQ_KHZ_F		4000.0	
#define OSCCLK_FREQ_KHZ		   4000	

#define PLL_USED_FOR_BUS	/* Enable PLL. Bus frequency =   */
									/*   fosc * multiplier / divider */
/*4MHz XTAL, 40MHz bus */ 
#define REFDV   0x40
#define SYNR    0x49
#define POSTDIV 0x00
									
#define SYNDIV (SYNR & 0x3F)
#define REFDIV (REFDV & 0x3F)

/**** MCU Defines ****/

#define BUSCLK_FREQ_KHZ_MAX 50000L	/* "L" postfix evaluated as a long value */

                             
	/* OSC based bus => Bus frequency in kHz = fosc / 2 */
#define BUSCLK_FREQ_KHZ_OSC		OSCCLK_FREQ_KHZ/2

   /* PLL based bus => bus frequency =          fosc * (SYNR+1)  
                                            -----------------------
                                            2 * POSTDIV * (REFDV+1)         
      if POSTDIV = 0 then (2*POSTDIV) = 1                                     */

#if POSTDIV == 0
#define BUSCLK_FREQ_KHZ_PLL ((OSCCLK_FREQ_KHZ*(SYNDIV+1))/(REFDIV+1))
#else
#define BUSCLK_FREQ_KHZ_PLL ((OSCCLK_FREQ_KHZ*(SYNDIV+1))/(2*POSTDIV*(REFDIV+1)))
#endif

#if(BUSCLK_FREQ_KHZ_PLL > BUSCLK_FREQ_KHZ_MAX)
#error PLL clock out of range.
#endif /* Incorrect PLL frequency. */		

#ifdef PLL_USED_FOR_BUS
#define BUSCLK_FREQ_KHZ BUSCLK_FREQ_KHZ_PLL
#else
#define BUSCLK_FREQ_KHZ BUSCLK_FREQ_KHZ_OSC
#endif

#define ECLKDIV 1          /* must be 1 to 32 */ 


#define FCLK_PRESCALER OSCCLK_FREQ_KHZ/1000 /* rough estimation */ 

/* SCI defines */ 
#define TERMINAL_BAUD_RATE	9600
#define SPARE_BAUD_RATE 	9600

#define TERMINAL_SCI SCI0
#define SPARE_SCI SCI1

#define TERMINAL_BAUD_OSC ((BUSCLK_FREQ_KHZ_OSC * 10) / (16 * (TERMINAL_BAUD_RATE / 100)))
#define SPARE_BAUD_OSC ((BUSCLK_FREQ_KHZ_OSC * 10) / (16 * (SPARE_BAUD_RATE / 100)))

#define TERMINAL_BAUD_PLL ((BUSCLK_FREQ_KHZ_PLL * 10) / (16 * (TERMINAL_BAUD_RATE / 100)))
#define SPARE_BAUD_PLL ((BUSCLK_FREQ_KHZ_PLL * 10) / (16 * (SPARE_BAUD_RATE / 100)))

/*CAN bit rate defines */
#define CAN0_KBPS 	50	/* 1000 kbps MAXIMUM */
#define CAN0_TQPB	8		/* 8 Tq per bit */

#if((OSCCLK_FREQ_KHZ / (CAN0_KBPS * CAN0_TQPB)) < 1)
#define CANBTR0_T2 (0x40)
//#elif((OSCCLK_FREQ_KHZ % (CAN0_KBPS * CAN0_TQPB)) == 0)
#define CANBTR0_T2 (0x40 + (UINT8)(OSCCLK_FREQ_KHZ / (CAN0_KBPS * CAN0_TQPB)) - 1)
#else
#define CANBTR0_T2 (0x40 + (UINT8)(OSCCLK_FREQ_KHZ / (CAN0_KBPS * CAN0_TQPB)))
#endif

#define CANBTR1_T2 0x14	/* SAMP = 0, TSEG2 = 2, TSEG1 = 5, 8 Tq per bit */

#endif /* TARGET_H */
